#pragma once


#define SONY_PLATFORM 1

#include "PrxPluginInterface.h"

#include <np_toolkit.h>



// Application data passed from the player.
//	THIS MUST MATCH DEFINITIONS IN THE PLAYERS, ALL PLAYERS.
struct PrxPluginArgs
{
	PrxPluginArgs() : m_Size(0) ,m_Version(0) {}
	static const uint32_t s_Version = 0x0103;
	uint32_t m_Size;
	uint32_t m_Version;
	const void* m_NpCommunicationId;			//	Cast to SceNpCommunicationId* if used by plugin (defined as void* to avoid all native plugins requiring NP header file inclusion)
	const void* m_NpCommunicationSignature;		//	Cast to SceNpCommunicationSignature*
	const void* m_NpCommunicationPassphrase;	//	Cast to SceNpCommunicationPassphrase*
	bool m_NpHasTrophyPack;
	const char* m_NpServiceID;
	const char* m_TitleID;
	int m_NpAgeRating;
	bool m_Trial;
	void* m_SpursInstance;
	bool m_bDevelopment;						//	Added in >0x0102 (TRUE in Development Build, FALSE in Non-Development)
	fnPrxPluginQueryInterface m_QueryInteface;	//	Added in >0x0103 (if available contains a function ptr to QueryInterface, otherwise NULL)
};

extern PrxPluginArgs gAppInfo; 

//	COMPONENT CAPABILITIES DEFINED HERE
#define	NP_HAS_ERROR_CODES		(SN_TARGET_PSP2 || SN_TARGET_PS3 || __ORBIS__ )
#define	NP_HAS_RANKING			(SN_TARGET_PSP2 || SN_TARGET_PS3 || __ORBIS__ )
#define	NP_HAS_BANDWIDTH		(SN_TARGET_PSP2 || SN_TARGET_PS3 || __ORBIS__ )
#define	NP_HAS_FRIENDS_LIST		(SN_TARGET_PSP2 || SN_TARGET_PS3 || __ORBIS__ )
#define	NP_HAS_ONLINE_PRESENCE	(SN_TARGET_PSP2 || SN_TARGET_PS3 || __ORBIS__ )
#define	NP_HAS_TROPHIES			(SN_TARGET_PSP2 || SN_TARGET_PS3 || __ORBIS__ )	//	Already exists on PS3 and must be removed before we can let NPToolkit take on responsibilities	
#define	NP_HAS_MATCHING			(SN_TARGET_PSP2 || SN_TARGET_PS3 || __ORBIS__ )
#define	NP_HAS_WORD_FILTER		(SN_TARGET_PSP2 || SN_TARGET_PS3 || __ORBIS__ )
#define	NP_HAS_MESSAGING		(SN_TARGET_PSP2 || SN_TARGET_PS3 || __ORBIS__ )
#define	NP_HAS_TUSTSS			(SN_TARGET_PSP2 || SN_TARGET_PS3 || __ORBIS__ )
#define	NP_HAS_COMMERCE			(SN_TARGET_PSP2 || SN_TARGET_PS3 || __ORBIS__ )
#define	NP_HAS_NP_DIALOGS		(SN_TARGET_PSP2 || __ORBIS__ )	//	Does not exist on PS3
#define NP_HAS_NP_FACEBOOK		(SN_TARGET_PSP2 || SN_TARGET_PS3 || __ORBIS__  )
#define NP_HAS_TWITTER			(SN_TARGET_PSP2)
#define	NP_HAS_NEAR				(SN_TARGET_PSP2)
#define NP_HAS_NP_COMMERCE		(SN_TARGET_PSP2 || SN_TARGET_PS3 || __ORBIS__  )
#define	NP_HAS_TICKETING		(SN_TARGET_PSP2 || SN_TARGET_PS3)
#define	NP_HAS_INVITES			(__ORBIS__)
#define NP_HAS_NP_REQUESTS		(__ORBIS__)


//	Vita flavoured things that are not defined in PS3
//	TODO:FIXME:AM
typedef	unsigned char	SceChar8;
typedef	unsigned int	SceInt32;
typedef	unsigned int	SceSize;
typedef unsigned int	SceUInt32;
typedef unsigned long long SceUInt64_t;
typedef bool			SceBool;
typedef	SceUInt64_t		SceRtcTick;
typedef SceInt32		SceNpTrophyGroupId;
#define vsnprintf_s vsnprintf
//	These four are for testing only
extern const SceNpCommunicationId s_np_communication_id;
extern	SceNpCommunicationPassphrase s_np_com_passphrase;
extern const SceNpCommunicationSignature s_npcommsign;
extern	const std::string s_serviceId;
//#define	USE_DUMMY_PS3_COMMSIDS 1

#define PRX_EXPORT extern "C" __declspec (dllexport)
#define	DO_EXPORT( _type, _func ) PRX_EXPORT _type _func
#include <sys/prx.h>
#include <sys/exportcplusplus.h>
#undef	PRX_EXPORT
#define PRX_EXPORT extern "C"
#undef	DO_EXPORT
//	PS3 function names must be explicitly exported
//	Use PRX_EXPORT in Header files for declarations
//	Use DO_EXPORT in CPP files for implementations
//	DO_EXPORT will (via preprocessor) just fallback to PRX_EXPORT on non-PS3 platforms
#define	DO_EXPORT( _type, _func ) SYS_LIB_EXPORT( _func, UnityNpToolkit ); \
	PRX_EXPORT _type _func
// TODO:

